/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import tcintegrations.common.capabilities.CapabilityRegistry;

public class BotaniaSet {
    private boolean terrestrial = false;
    private boolean greatFairy = false;

    public static Tag writeNBT(Capability<BotaniaSet> capability, BotaniaSet instance, Direction side) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("terrestrial", instance.hasTerrestrial());
        tag.m_128379_("great_fairy", instance.hasGreatFairy());
        return tag;
    }

    public static void readNBT(Capability<BotaniaSet> capability, BotaniaSet instance, Direction side, Tag nbt) {
        instance.setTerrestrial(((CompoundTag)nbt).m_128471_("terrestrial"));
        instance.setGreatFairy(((CompoundTag)nbt).m_128471_("great_fairy"));
    }

    public void setTerrestrial(boolean terrestrial) {
        this.terrestrial = terrestrial;
    }

    public boolean hasTerrestrial() {
        return this.terrestrial;
    }

    public void setGreatFairy(boolean greatFairy) {
        this.greatFairy = greatFairy;
    }

    public boolean hasGreatFairy() {
        return this.greatFairy;
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        @Nonnull
        private final BotaniaSet instance = new BotaniaSet();
        private final LazyOptional<BotaniaSet> handler = LazyOptional.of(this::getInstance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == null) {
                return LazyOptional.empty();
            }
            return CapabilityRegistry.BOTANIA_SET_CAPABILITY.orEmpty(cap, this.handler);
        }

        public BotaniaSet getInstance() {
            return this.instance;
        }

        public Tag serializeNBT() {
            return BotaniaSet.writeNBT(CapabilityRegistry.BOTANIA_SET_CAPABILITY, this.instance, null);
        }

        public void deserializeNBT(Tag nbt) {
            BotaniaSet.readNBT(CapabilityRegistry.BOTANIA_SET_CAPABILITY, this.instance, null, nbt);
        }
    }
}

